/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.impexp;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.impexp.AbstractExcelExporter;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class ArrayExcelExporter
extends AbstractExcelExporter {
    private Properties context = null;
    private ArrayList<ArrayList<Object>> data = null;

    public ArrayExcelExporter(Properties context, ArrayList<ArrayList<Object>> data, Boolean dataIncludeHeader) {
        this.context = context;
        this.data = data;
        this.dataIncludeHeader = dataIncludeHeader;
    }

    @Override
    public Properties getCtx() {
        return this.context;
    }

    @Override
    public int getColumnCount() {
        return this.data.get(0).size();
    }

    @Override
    public int getDisplayType(int row, int col) {
        ArrayList<Object> dataRow = this.data.get(row);
        Object value = dataRow.get(col);
        if (value != null) {
            if (value instanceof Timestamp) {
                return 15;
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    return 11;
                }
                return 22;
            }
            if (value instanceof Boolean) {
                return 20;
            }
            return 10;
        }
        return -1;
    }

    @Override
    public String getHeaderName(int col) {
        Object o = this.data.get(0).get(col);
        String name = o != null ? o.toString() : null;
        String nameTrl = Msg.translate(this.getLanguage(), name);
        if (Util.isEmpty(nameTrl)) {
            nameTrl = name;
        }
        return nameTrl;
    }

    @Override
    public String getFormatPattern(int col) {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        ArrayList<Object> dataRow = this.data.get(row);
        Object value = dataRow.get(col);
        return value;
    }

    @Override
    public boolean isColumnPrinted(int col) {
        return true;
    }

    @Override
    public boolean isFunctionRow() {
        return false;
    }

    @Override
    public boolean isPageBreak(int row, int col) {
        return false;
    }

    @Override
    protected void setCurrentRow(int row) {
    }
}

