/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.I_C_ProjectIssue;
import org.adempiere.core.domains.models.I_M_CostElement;
import org.adempiere.core.domains.models.I_M_CostType;
import org.adempiere.core.domains.models.I_M_InOut;
import org.adempiere.core.domains.models.I_M_Inventory;
import org.adempiere.core.domains.models.I_M_MatchInv;
import org.adempiere.core.domains.models.I_M_MatchPO;
import org.adempiere.core.domains.models.I_M_Movement;
import org.adempiere.core.domains.models.I_M_Product;
import org.adempiere.core.domains.models.I_M_Production;
import org.adempiere.core.domains.models.I_PP_Cost_Collector;
import org.adempiere.core.domains.models.X_PP_Cost_Collector;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.CostingMethodFactory;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovementLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductPO;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class CostEngine {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    public static final int[] documentsTableID = new int[]{I_M_InOut.Table_ID, I_M_Inventory.Table_ID, I_M_Movement.Table_ID, I_M_Product.Table_ID, I_C_ProjectIssue.Table_ID, I_PP_Cost_Collector.Table_ID, I_M_MatchPO.Table_ID, I_M_MatchInv.Table_ID};
    public static final String[] documentsTableName = new String[]{"M_InOut", "M_Inventory", "M_Movement", "M_Production", "C_ProjectIssue", "PP_Cost_Collector", "M_MatchPO", "M_MatchInv"};

    public static BigDecimal getSeedCost(Properties context, int productId, String trxName) {
        BigDecimal costThisLevel = Env.ZERO;
        for (MProductPO productPO : MProductPO.getOfProduct(context, productId, trxName)) {
            if (!productPO.isCurrentVendor()) continue;
            costThisLevel = productPO.getPriceLastInv().signum() != 0 ? productPO.getPriceLastInv() : (productPO.getPriceLastPO().signum() != 0 ? productPO.getPriceLastPO() : (productPO.getPricePO().signum() != 0 ? productPO.getPricePO() : productPO.getPriceList()));
            return costThisLevel;
        }
        return costThisLevel;
    }

    public static BigDecimal getParentActualCostByCostType(MAcctSchema accountSchema, int costTypeId, int costElementId, X_PP_Cost_Collector costCollector) {
        StringBuffer whereClause = new StringBuffer().append("C_AcctSchema_ID").append("=? AND ").append("M_CostType_ID=? AND ").append("M_CostElement_ID=? AND ").append("PP_Cost_Collector_ID").append(" IN (SELECT PP_Cost_Collector_ID FROM PP_Cost_Collector cc WHERE cc.PP_Order_ID=? AND ").append(" cc.CostCollectorType <> '").append("100").append("')");
        List componentsIssue = new Query(costCollector.getCtx(), "M_CostDetail", whereClause.toString(), costCollector.get_TrxName()).setClient_ID().setParameters(accountSchema.getC_AcctSchema_ID(), costTypeId, costElementId, costCollector.getPP_Order_ID()).list();
        AtomicReference<BigDecimal> actualCostReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        componentsIssue.stream().forEach(costDetail -> {
            if (costDetail.getQty().signum() < 0) {
                actualCostReference.updateAndGet(cost -> cost.subtract(costDetail.getAmt().add(costDetail.getAmtLL())));
            } else {
                actualCostReference.updateAndGet(cost -> cost.add(costDetail.getAmt().add(costDetail.getAmtLL())));
            }
        });
        BigDecimal actualCost = actualCostReference.get();
        whereClause = new StringBuffer();
        whereClause.append(" EXISTS (SELECT 1 FROM PP_Cost_Collector cc ").append(" WHERE PP_Cost_Collector_ID=M_Transaction.PP_Cost_Collector_ID AND cc.PP_Order_ID=? AND cc.M_Product_ID=? )");
        BigDecimal qtyDelivered = new Query(costCollector.getCtx(), "M_Transaction", whereClause.toString(), costCollector.get_TrxName()).setClient_ID().setParameters(costCollector.getPP_Order_ID(), costCollector.getM_Product_ID()).sum("MovementQty");
        if (actualCost == null) {
            actualCost = Env.ZERO;
        }
        if (qtyDelivered.signum() != 0) {
            actualCost = actualCost.divide(qtyDelivered, accountSchema.getCostingPrecision(), RoundingMode.HALF_DOWN);
        }
        int conversionTypeId = MConversionType.getDefault(costCollector.getAD_Client_ID());
        MClient client = MClient.get(costCollector.getCtx());
        int currencyId = client.getC_Currency_ID();
        BigDecimal rate = MConversionRate.getRate(currencyId, currencyId, costCollector.getDateAcct(), conversionTypeId, costCollector.getAD_Client_ID(), costCollector.getAD_Org_ID());
        if (rate != null && (actualCost = actualCost.multiply(rate)).scale() > accountSchema.getCostingPrecision()) {
            actualCost = actualCost.setScale(accountSchema.getCostingPrecision(), RoundingMode.HALF_UP);
        }
        return actualCost;
    }

    public static BigDecimal getParentActualCostByCostType(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, I_M_Production production) {
        BigDecimal totalCost = Env.ZERO;
        for (MProductionLine productionLine : ((MProduction)production).getLines()) {
            MCost costDimension;
            if (productionLine.isParent()) continue;
            String productType = productionLine.getM_Product().getProductType();
            BigDecimal cost = BigDecimal.ZERO;
            if ("I".equals(productType)) {
                cost = MCostDetail.getCostByModel(accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), productionLine);
            } else if ("R".equals(productType) && (costDimension = MCost.validateCostForCostType(accountSchema, costType, costElement, productionLine.getM_Product_ID(), productionLine.getAD_Org_ID(), productionLine.getM_Locator().getM_Warehouse_ID(), productionLine.getM_AttributeSetInstance_ID(), productionLine.get_TrxName())) != null && costDimension.getCurrentCostPrice().signum() != 0) {
                cost = costDimension.getCurrentCostPrice().multiply(productionLine.getMovementQty().negate());
            }
            if (cost == null || cost.signum() == 0) continue;
            totalCost = totalCost.add(cost);
        }
        BigDecimal unitCost = Env.ZERO;
        if (production.getProductionQty().signum() != 0 && totalCost.signum() != 0) {
            unitCost = totalCost.divide(production.getProductionQty(), accountSchema.getCostingPrecision(), RoundingMode.HALF_UP);
        }
        return unitCost;
    }

    public static BigDecimal roundCost(BigDecimal price, int accountSchemaId) {
        int precision = MAcctSchema.get(Env.getCtx(), accountSchemaId).getCostingPrecision();
        BigDecimal priceRounded = price;
        if (priceRounded.scale() > precision) {
            priceRounded = priceRounded.setScale(precision, RoundingMode.HALF_UP);
        }
        return priceRounded;
    }

    public void createCostDetail(MTransaction transaction, IDocumentLine model) {
        MClient client = MClient.get(transaction.getCtx());
        StringBuilder description = new StringBuilder();
        if (model != null && model.getDescription() != null && !Util.isEmpty(model.getDescription(), true)) {
            description.append(model.getDescription());
        }
        if (model != null) {
            description.append(model.isSOTrx() ? "(|->)" : "(|<-)");
        }
        ArrayList<MAcctSchema> acctSchemas = new ArrayList<MAcctSchema>(Arrays.asList(MAcctSchema.getClientAcctSchema(transaction.getCtx(), transaction.getAD_Client_ID(), transaction.get_TrxName())));
        List<MCostElement> costElements = MCostElement.getCostElement(transaction.getCtx(), transaction.get_TrxName());
        List<MCostType> costTypes = MCostType.get(transaction.getCtx(), transaction.get_TrxName());
        for (MAcctSchema accountSchema : acctSchemas) {
            for (MCostType costType : costTypes) {
                if (!costType.isActive()) continue;
                for (MCostElement costElement : costElements) {
                    this.createCostDetail(accountSchema, costType, costElement, transaction, model, client.isCostImmediate());
                }
            }
        }
    }

    public void createCostDetail(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, MTransaction transaction, IDocumentLine model, boolean force) {
        BigDecimal costMovementFromLL;
        BigDecimal costMovementFrom;
        MTransaction transactionFrom;
        MInventoryLine inventoryLine;
        if (!force) {
            return;
        }
        BigDecimal costThisLevel = Env.ZERO;
        BigDecimal costLowLevel = Env.ZERO;
        String costingLevel = MProduct.get(transaction.getCtx(), transaction.getM_Product_ID()).getCostingLevel(accountSchema, transaction.getAD_Org_ID());
        if (model instanceof MMatchInv && "A".equals(costType.getCostingMethod())) {
            return;
        }
        if (model instanceof MMatchPO && "I".equals(costType.getCostingMethod())) {
            return;
        }
        if (model instanceof MLandedCostAllocation) {
            MLandedCostAllocation allocation = (MLandedCostAllocation)model;
            costThisLevel = allocation.getPriceActual();
        }
        MCost cost = MCost.validateCostForCostType(accountSchema, costType, costElement, transaction.getM_Product_ID(), transaction.getAD_Org_ID(), transaction.getM_Warehouse_ID(), transaction.getM_AttributeSetInstance_ID(), transaction.get_TrxName());
        if (("M".equals(costElement.getCostElementType()) || "L".equals(costElement.getCostElementType())) && transaction.getMovementType().contains("+") && !"S".equals(costType.getCostingMethod())) {
            if (model instanceof MMovementLine || model instanceof MInventoryLine || model instanceof MInOutLine && "C+".equals(transaction.getMovementType())) {
                costThisLevel = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                costLowLevel = CostEngine.getCostLowLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                if (model instanceof MInventoryLine) {
                    inventoryLine = (MInventoryLine)model;
                    if (costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                        if (inventoryLine.getQtyInternalUse().signum() == 0 && inventoryLine.getCurrentCostPrice() != null && inventoryLine.getCurrentCostPrice().signum() > 0) {
                            costThisLevel = this.convertCostToSchemaCurrency(accountSchema, model, model.getPriceActualCurrency());
                        }
                        if (costThisLevel.signum() == 0) {
                            costThisLevel = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                        }
                    }
                    if (costLowLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                        if (inventoryLine.getQtyInternalUse().signum() == 0 && inventoryLine.getCurrentCostPriceLL() != null && inventoryLine.getCurrentCostPriceLL().signum() > 0) {
                            costLowLevel = this.convertCostToSchemaCurrency(accountSchema, model, inventoryLine.getCurrentCostPriceLL());
                        }
                        if (costLowLevel.signum() == 0) {
                            costLowLevel = CostEngine.getCostLowLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                        }
                    }
                }
                if (model instanceof MMovementLine) {
                    transactionFrom = MTransaction.getByDocumentLine(model, "M-");
                    costMovementFrom = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transactionFrom == null ? transaction : transactionFrom, model, costingLevel);
                    if (costMovementFrom.signum() > 0) {
                        costThisLevel = costMovementFrom;
                    }
                    if ((costMovementFromLL = CostEngine.getCostLowLevel(accountSchema, costType, costElement, transactionFrom == null ? transaction : transactionFrom, model, costingLevel)).signum() > 0) {
                        costLowLevel = costMovementFromLL;
                    }
                }
            } else if ("M".equals(costElement.getCostElementType())) {
                costThisLevel = this.convertCostToSchemaCurrency(accountSchema, model, model.getPriceActualCurrency());
            }
        }
        if (!"S".equals(costType.getCostingMethod())) {
            X_PP_Cost_Collector costCollector;
            if (model.get_TableName().equals("PP_Cost_Collector") && "100".equals((costCollector = (X_PP_Cost_Collector)((Object)model)).getCostCollectorType())) {
                costThisLevel = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                costLowLevel = CostEngine.getParentActualCostByCostType(accountSchema, costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), costCollector);
            }
            if (model instanceof MProductionLine) {
                MProductionLine productionLine = (MProductionLine)model;
                if (productionLine.isParent()) {
                    costThisLevel = CostEngine.getParentActualCostByCostType(accountSchema, costType, costElement, productionLine.getM_Production());
                }
                if (costThisLevel.signum() == 0) {
                    costThisLevel = cost.getCurrentCostPrice();
                }
                if (costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                    costThisLevel = CostEngine.getSeedCost(transaction.getCtx(), transaction.getM_Product_ID(), transaction.get_TrxName());
                }
                if (productionLine.isParent()) {
                    if (!productionLine.getM_Product().isPurchased()) {
                        costLowLevel = costThisLevel;
                        costThisLevel = Env.ZERO;
                    }
                } else if (productionLine.getMovementQty().signum() < 0) {
                    costLowLevel = Env.ZERO;
                }
            }
        } else if ("S".equals(costType.getCostingMethod())) {
            costThisLevel = cost.getCurrentCostPrice();
            costLowLevel = cost.getCurrentCostPriceLL();
            if (model instanceof MInventoryLine) {
                inventoryLine = (MInventoryLine)model;
                if (costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                    if (inventoryLine.getQtyInternalUse().signum() == 0 && inventoryLine.getCurrentCostPrice() != null && inventoryLine.getCurrentCostPrice().signum() > 0) {
                        costThisLevel = this.convertCostToSchemaCurrency(accountSchema, model, model.getPriceActualCurrency());
                        cost.setCurrentCostPrice(costThisLevel);
                        cost.saveEx();
                    }
                    if (costThisLevel.signum() == 0) {
                        costThisLevel = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                    }
                }
                if (costLowLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                    if (inventoryLine.getQtyInternalUse().signum() == 0 && inventoryLine.getCurrentCostPriceLL() != null && inventoryLine.getCurrentCostPriceLL().signum() > 0) {
                        costLowLevel = this.convertCostToSchemaCurrency(accountSchema, model, inventoryLine.getCurrentCostPriceLL());
                        cost.setCurrentCostPriceLL(costLowLevel);
                        cost.saveEx();
                    }
                    if (costLowLevel.signum() == 0) {
                        costLowLevel = CostEngine.getCostLowLevel(accountSchema, costType, costElement, transaction, model, costingLevel);
                    }
                }
            }
            if (model instanceof MMovementLine) {
                transactionFrom = MTransaction.getByDocumentLine(model, "M-");
                costMovementFrom = CostEngine.getCostThisLevel(accountSchema, costType, costElement, transactionFrom == null ? transaction : transactionFrom, model, costingLevel);
                if (costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType()) && costMovementFrom.signum() > 0) {
                    costThisLevel = costMovementFrom;
                }
                if (costLowLevel.signum() == 0 && "M".equals(costElement.getCostElementType()) && (costMovementFromLL = CostEngine.getCostLowLevel(accountSchema, costType, costElement, transactionFrom == null ? transaction : transactionFrom, model, costingLevel)).signum() > 0) {
                    costLowLevel = costMovementFromLL;
                }
            }
            if (costThisLevel.signum() == 0 && "M".equals(costElement.getCostElementType())) {
                costThisLevel = CostEngine.getSeedCost(transaction.getCtx(), transaction.getM_Product_ID(), transaction.get_TrxName());
                if (costThisLevel.signum() == 0 && model instanceof MInOutLine && !model.isSOTrx()) {
                    costThisLevel = this.convertCostToSchemaCurrency(accountSchema, model, model.getPriceActualCurrency());
                }
                if (costThisLevel.signum() != 0) {
                    cost.setCurrentCostPrice(costThisLevel);
                    cost.saveEx();
                }
            }
            if (costLowLevel.signum() != 0) {
                cost.setCurrentCostPriceLL(costLowLevel);
                cost.saveEx();
            }
        }
        ICostingMethod method = CostingMethodFactory.get().getCostingMethod(costType.getCostingMethod());
        method.setCostingMethod(accountSchema, transaction, model, cost, costThisLevel, costLowLevel, model.isSOTrx());
        method.process();
    }

    private BigDecimal convertCostToSchemaCurrency(MAcctSchema acctSchema, IDocumentLine model, BigDecimal cost) {
        BigDecimal totalCostThisLevel = MConversionRate.convertBase(model.getCtx(), cost, model.getC_Currency_ID(), model.getDateAcct(), model.getC_ConversionType_ID(), model.getAD_Client_ID(), model.getAD_Org_ID());
        return totalCostThisLevel;
    }

    public void createCostDetailForLandedCostAllocation(MLandedCostAllocation allocation) {
        MInOutLine ioLine = (MInOutLine)allocation.getM_InOutLine();
        for (MTransaction transaction : MTransaction.getByInOutLine(ioLine)) {
            for (MAcctSchema accountSchema : MAcctSchema.getClientAcctSchema(allocation.getCtx(), allocation.getAD_Client_ID())) {
                List<MCostType> costTypes = MCostType.get(allocation.getCtx(), allocation.get_TrxName());
                for (MCostType costType : costTypes) {
                    MCostElement costElement = (MCostElement)allocation.getM_CostElement();
                    CostEngineFactory.getCostEngine(allocation.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, allocation, true);
                }
            }
        }
    }

    public static boolean isActivityControlElement(I_M_CostElement element) {
        String costElementType = element.getCostElementType();
        return "R".equals(costElementType) || "O".equals(costElementType) || "B".equals(costElementType) || "X".equals(costElementType);
    }

    public static List<MAcctSchema> getAcctSchema(PO po) {
        int AD_Org_ID = po.getAD_Org_ID();
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(po.getCtx(), po.getAD_Client_ID());
        ArrayList<MAcctSchema> list = new ArrayList<MAcctSchema>(ass.length);
        for (MAcctSchema as : ass) {
            if (as.isSkipOrg(AD_Org_ID)) continue;
            list.add(as);
        }
        return list;
    }

    public static String getIDColumnName(IDocumentLine model) {
        Object idColumnName = model.get_TableName() + "_ID";
        if (model instanceof MMatchPO) {
            idColumnName = "C_OrderLine_ID";
        }
        if (model instanceof MMatchInv) {
            idColumnName = "C_InvoiceLine_ID";
        }
        return idColumnName;
    }

    public static int getIDColumn(IDocumentLine model) {
        int id = model.get_ID();
        if (model instanceof MMatchPO) {
            id = ((MMatchPO)model).getC_OrderLine_ID();
        }
        if (model instanceof MMatchInv) {
            id = ((MMatchInv)model).getC_InvoiceLine_ID();
        }
        return id;
    }

    public static BigDecimal getCostThisLevel(MAcctSchema accountSchema, I_M_CostType costType, I_M_CostElement costElement, MTransaction transaction, IDocumentLine model, String costingLevel) {
        BigDecimal costThisLevel = Env.ZERO;
        MCostDetail lastCostDetail = MCostDetail.getLastTransaction(model, transaction, accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), model.getDateAcct(), costingLevel);
        if (lastCostDetail != null) {
            if (lastCostDetail.getQty().signum() != 0) {
                costThisLevel = lastCostDetail.getCostAmt().add(lastCostDetail.getCostAdjustment()).divide(lastCostDetail.getQty(), accountSchema.getCostingPrecision(), RoundingMode.HALF_UP).abs();
            } else {
                if (lastCostDetail.getCumulatedQty().add(lastCostDetail.getQty()).signum() != 0) {
                    costThisLevel = lastCostDetail.getCostAmt().add(lastCostDetail.getCostAdjustment()).add(lastCostDetail.getCumulatedAmt()).divide(lastCostDetail.getCumulatedQty().add(lastCostDetail.getQty()), accountSchema.getCostingPrecision(), RoundingMode.HALF_UP).abs();
                    return costThisLevel;
                }
                if (lastCostDetail.getCumulatedQty().signum() != 0) {
                    costThisLevel = lastCostDetail.getCumulatedAmt().divide(lastCostDetail.getCumulatedQty(), accountSchema.getCostingPrecision(), RoundingMode.HALF_UP).abs();
                    return costThisLevel;
                }
            }
        }
        return costThisLevel;
    }

    public static BigDecimal getCostLowLevel(MAcctSchema accountSchema, I_M_CostType costType, I_M_CostElement costElement, MTransaction transaction, IDocumentLine model, String costingLevel) {
        BigDecimal costLowLevel = Env.ZERO;
        MCostDetail lastCostDetail = MCostDetail.getLastTransaction(model, transaction, accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), model.getDateAcct(), costingLevel);
        if (lastCostDetail != null) {
            if (lastCostDetail.getQty().signum() != 0) {
                costLowLevel = lastCostDetail.getCostAmtLL().add(lastCostDetail.getCostAdjustmentLL()).divide(lastCostDetail.getQty(), accountSchema.getCostingPrecision(), RoundingMode.HALF_UP).abs();
            } else {
                if (lastCostDetail.getCumulatedQty().add(lastCostDetail.getQty()).signum() != 0) {
                    costLowLevel = lastCostDetail.getCostAmtLL().add(lastCostDetail.getCostAdjustmentLL()).add(lastCostDetail.getCumulatedAmtLL()).divide(lastCostDetail.getCumulatedQty().add(lastCostDetail.getQty()), accountSchema.getCostingPrecision(), RoundingMode.HALF_UP).abs();
                    return costLowLevel;
                }
                if (lastCostDetail.getCumulatedQty().signum() != 0) {
                    costLowLevel = lastCostDetail.getCumulatedAmtLL().divide(lastCostDetail.getCumulatedQty(), accountSchema.getCostingPrecision(), RoundingMode.HALF_UP).abs();
                    return costLowLevel;
                }
            }
        }
        return costLowLevel;
    }

    public void clearAccounting(MAcctSchema accountSchema, MTransaction transaction) {
        if (transaction.getM_InOutLine_ID() > 0) {
            MInOutLine line = (MInOutLine)transaction.getM_InOutLine();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line.getParent(), transaction.getM_Product_ID(), line.getDateAcct())) {
                return;
            }
            List<MMatchPO> orderMatches = MMatchPO.getInOutLine(line);
            for (MMatchPO match : orderMatches) {
                if (this.clearAccounting(accountSchema, accountSchema.getM_CostType(), match, transaction.getM_Product_ID(), line.getDateAcct())) continue;
                return;
            }
            List<MMatchInv> invoiceMatches = MMatchInv.getInOutLine(line);
            for (MMatchInv match : invoiceMatches) {
                if (this.clearAccounting(accountSchema, accountSchema.getM_CostType(), match, transaction.getM_Product_ID(), line.getDateAcct())) continue;
                return;
            }
        } else if (transaction.getC_ProjectIssue_ID() > 0) {
            MProjectIssue line = (MProjectIssue)transaction.getC_ProjectIssue();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line, transaction.getM_Product_ID(), line.getMovementDate())) {
                return;
            }
        } else if (transaction.getM_InventoryLine_ID() > 0) {
            MInventoryLine line = (MInventoryLine)transaction.getM_InventoryLine();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line.getParent(), transaction.getM_Product_ID(), line.getDateAcct())) {
                return;
            }
        } else if (transaction.getM_MovementLine_ID() > 0) {
            MMovementLine line = (MMovementLine)transaction.getM_MovementLine();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), line.getParent(), transaction.getM_Product_ID(), line.getDateAcct())) {
                return;
            }
        } else if (transaction.getM_ProductionLine_ID() > 0) {
            MProductionLine line = (MProductionLine)transaction.getM_ProductionLine();
            MProduction production = (MProduction)line.getM_ProductionPlan().getM_Production();
            if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), production, transaction.getM_Product_ID(), production.getMovementDate())) {
                return;
            }
        } else {
            if (transaction.getPP_Cost_Collector_ID() > 0) {
                X_PP_Cost_Collector costCollector = (X_PP_Cost_Collector)transaction.getPP_Cost_Collector();
                if (!this.clearAccounting(accountSchema, accountSchema.getM_CostType(), costCollector, costCollector.getM_Product_ID(), costCollector.getDateAcct())) {
                    // empty if block
                }
                return;
            }
            this.log.info("Document does not exist :" + transaction);
        }
    }

    public boolean clearAccounting(MAcctSchema accountSchema, I_M_CostType costType, PO model, int productId, Timestamp dateAcct) {
        String docBaseType;
        if (!accountSchema.getCostingMethod().equals(costType.getCostingMethod())) {
            MProduct product = MProduct.get(accountSchema.getCtx(), productId);
            MProductCategoryAcct productCategoryAcct = MProductCategoryAcct.get(accountSchema.getCtx(), product.getM_Product_Category_ID(), accountSchema.get_ID(), model.get_TrxName());
            if (productCategoryAcct == null || !costType.getCostingMethod().equals(productCategoryAcct.getCostingMethod())) {
                return false;
            }
        }
        if (model instanceof MMatchInv) {
            docBaseType = "MXI";
        } else if (model instanceof MMatchPO) {
            docBaseType = "MXP";
        } else if (model instanceof MProduction) {
            docBaseType = "MMP";
        } else {
            MDocType docType = MDocType.get(model.getCtx(), model.get_ValueAsInt("C_DocType_ID"));
            docBaseType = docType.getDocBaseType();
        }
        Boolean openPeriod = MPeriod.isOpen(model.getCtx(), dateAcct, docBaseType, model.getAD_Org_ID());
        if (!openPeriod.booleanValue()) {
            System.out.println("Period closed.");
            return false;
        }
        String sqlUpdate = "UPDATE " + model.get_TableName() + " SET Posted = 'N' WHERE " + model.get_TableName() + "_ID=?";
        DB.executeUpdate(sqlUpdate, new Object[]{model.get_ID()}, false, model.get_TrxName());
        String sqldelete = "DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?";
        DB.executeUpdate("DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?", new Object[]{model.get_ID(), model.get_Table_ID()}, false, model.get_TrxName());
        return true;
    }
}

