/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.AbstractBatchImport;
import org.compiere.impexp.ImpFormat;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public abstract class FileImportController {
    private static final int MAX_LOADED_LINES = 100;
    public static final int MAX_SHOWN_LINES = 10;
    private int windowNo = 0;
    private ArrayList<String> data = new ArrayList();
    private ImpFormat format;
    private int record = -1;
    private Charset charset;
    private InputStream inputStream;
    private static CLogger log = CLogger.getCLogger(FileImportController.class);
    public static final String s_none = "----";

    public void init(int windowNo) {
        log.info("");
        this.windowNo = windowNo;
    }

    public abstract void setBusy(boolean var1);

    public abstract void clearView();

    public abstract void clearPreview();

    public abstract void fillView();

    public abstract void fillInfoView();

    public abstract void addLine(String var1);

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public int getRecordNo() {
        return this.record;
    }

    public void addRecordNo(int recordToAdded) {
        this.record += recordToAdded;
    }

    public void setRecordNo(int record) {
        this.record = record;
    }

    public ImpFormatRow getRow(int index) {
        if (this.getRowCount() - 1 >= index) {
            return this.format.getRow(index);
        }
        return null;
    }

    public void readFromConnection() {
        this.clearView();
        if (this.format == null) {
            return;
        }
        this.setBusy(true);
        AbstractBatchImport connectionDataLoader = null;
        Class<?> clazz = this.format.getConnectionClass();
        if (clazz == null) {
            log.log(Level.INFO, "Using GenericDeviceHandler");
            return;
        }
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(Properties.class);
            connectionDataLoader = (AbstractBatchImport)constructor.newInstance(Env.getCtx());
            String error = connectionDataLoader.testConnetion();
            if (error != null) {
                log.warning("Connection error " + clazz + " (" + error + ")");
                return;
            }
            this.readData(connectionDataLoader.getData());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            log.warning("No transaction Constructor for " + clazz + " (" + msg + ")");
        }
        this.fillView();
        this.setBusy(false);
    }

    private void readData(List<String> externalData) {
        if (this.data == null) {
            return;
        }
        this.data.clear();
        this.clearView();
        for (String line : externalData) {
            this.data.add(line);
            if (this.data.size() > 100) continue;
            this.addLine(line);
            this.addLine("\n");
        }
        int index = 1;
        if (this.data.size() == 1) {
            index = 0;
        }
        int length = 0;
        if (this.data.size() > 0) {
            length = this.data.get(index).toString().length();
        }
        this.fillView();
        this.setBusy(false);
        log.config("Records=" + this.data.size() + ", Length=" + length);
    }

    public void cmd_reloadFile() {
        if (this.inputStream == null) {
            return;
        }
        this.cmd_reloadFile(this.inputStream);
    }

    public void cmd_reloadFile(InputStream inputStream) {
        this.inputStream = inputStream;
        if (inputStream == null) {
            return;
        }
        this.setBusy(true);
        this.data.clear();
        this.clearView();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, this.charset), 10240);
            String s = null;
            while ((s = in.readLine()) != null) {
                this.data.add(s);
                if (this.data.size() > 100) continue;
                this.addLine(s);
                this.addLine("\n");
            }
            in.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        int index = 1;
        if (this.data.size() == 1) {
            index = 0;
        }
        int length = 0;
        if (this.data.size() > 0) {
            length = this.data.get(index).toString().length();
        }
        this.fillView();
        this.setBusy(false);
        log.config("Records=" + this.data.size() + ", Length=" + length);
    }

    public int getDataSize() {
        if (this.data != null) {
            return this.data.size();
        }
        return 0;
    }

    public int getRowCount() {
        if (this.format != null) {
            return this.format.getRowCount();
        }
        return 0;
    }

    public int getRecordLength(int index) {
        if (this.getDataSize() - 1 >= index) {
            return this.data.get(index).length();
        }
        return 0;
    }

    public String[] parseLine(int index) {
        return this.format.parseLine(this.data.get(index), false, true, false);
    }

    public String loadFormat(String impFormat) {
        this.format = ImpFormat.load(impFormat);
        if (this.format == null) {
            return "FileImportNoFormat";
        }
        return null;
    }

    public boolean isFromConnection() {
        return this.format.isFromConnection();
    }

    public String cmd_process() throws AdempiereException {
        if (this.format == null) {
            throw new AdempiereException("FileImportNoFormat");
        }
        log.config(this.format.getName());
        int row = 0;
        int imported = 0;
        for (String line : this.data) {
            ++row;
            if (!this.format.updateDB(Env.getCtx(), line, null)) continue;
            ++imported;
        }
        this.data.clear();
        return "@FileImportR/I@ (" + row + " / " + imported + "#)";
    }
}

